<?php
add_action('acf/init', 'poker_acf_init');
function poker_acf_init()
{
    if (function_exists('acf_register_block')) {

        //steps block
        acf_register_block(array(
            'name'                => 'steps',
            'title'                => __('Steps'),
            'render_callback'    => 'poker_block_render_callback',
            'category'            => 'formatting',
            'icon'                => 'admin-comments',
            'keywords'            => array('steps', 'numbers'),
        ));

        //subtitle block
        acf_register_block(array(
            'name'                => 'subtitle',
            'title'                => __('Subtitle'),
            'render_callback'    => 'poker_block_render_callback',
            'category'            => 'formatting',
            'icon'                => 'admin-comments',
            'keywords'            => array('subtitle'),
        ));

        //image-text block
        acf_register_block(array(
            'name'                => 'image-text',
            'title'                => __('Image - Text'),
            'render_callback'    => 'poker_block_render_callback',
            'category'            => 'formatting',
            'icon'                => 'admin-comments',
            'keywords'            => array('image-text'),
        ));

        //subscription cards block
        acf_register_block(array(
            'name'                => 'subscription-card',
            'title'                => __('Subscription Card'),
            'render_callback'    => 'poker_block_render_callback',
            'category'            => 'formatting',
            'icon'                => 'admin-comments',
            'keywords'            => array('subscription'),
        ));
    }
}

function poker_block_render_callback($block)
{
    $slug = str_replace('acf/', '', $block['name']);
    if (file_exists(get_theme_file_path("/template-parts/block/content-{$slug}.php"))) {
        include(get_theme_file_path("/template-parts/block/content-{$slug}.php"));
    }
}
